DROP PROCEDURE [hips].[PatientMasterAddressDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 18 Oct 2012
-- Description:   Delete a record from the Patient Master Address Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterAddressDelete] 
(
	@PatientMasterId INT
	
)
AS
BEGIN
	SET NOCOUNT ON

    DECLARE @intErrorCode int,
		@intRowsAffected Int

    SET @intErrorCode = 0
	SELECT @intErrorCode = 0,
			@intRowsAffected = 0
			
	DELETE hips.PatientMasterAddress
	WHERE PatientMasterId = @PatientMasterId
	SELECT @intErrorCode = @@ERROR,
		@intRowsAffected = @@ROWCOuNT
	
	SELECT @intRowsAffected AS RowsAffected

    RETURN(@intErrorCode)


END
GO

